/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.specific;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * Return the firefox string with the major and minor version only. 
 * 
 * @author Tommaso Teofili
 * @author Filippo De Luca
 * 
 * @version $Id: FirefoxNormalizer.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class FirefoxNormalizer implements UserAgentNormalizer {

	/**
	 * Return the firefox string with the major and minor version only  
	 *
	 * @param userAgent
	 * @return String
	 */
	public String normalize(String userAgent) {
		
		String normalized = userAgent;
		
		if(StringUtils.contains(userAgent, "Firefox")) {
			int start = userAgent.indexOf("Firefox");
			normalized = StringUtils.substring(userAgent, start, start + 11);

		}
		
		return normalized;
	}

}
