/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.specific;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * This Normalizer returns Konqueror user agent with the major version.
 * 
 * e.g Mozilla/5.0 (compatible; Konqueror/4.1; Linux) KHTML/4.1.2 (like Gecko)
 * -> Konqueror/4
 * 
 * @author Tommaso Teofili
 * @author Filippo De Luca
 * 
 * @version $Id: KonquerorNormalizer.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class KonquerorNormalizer implements UserAgentNormalizer {

	/**
	 * Return the Konqueror user agent with the major version
	 * 
	 * e.g Mozilla/5.0 (compatible; Konqueror/4.1; Linux) KHTML/4.1.2 (like
	 * Gecko) -> Konqueror/4
	 * 
	 * @param userAgent
	 * @return String
	 */
	public String normalize(String userAgent) {

		String normalized = userAgent;

		if (StringUtils.contains(userAgent, "Konqueror")) {
			int start = userAgent.indexOf("Konqueror");
			normalized = StringUtils.substring(userAgent, start, start + 10);

		}

		return normalized;
	}

}
