/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.specific;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

public class MSIENormalizer implements UserAgentNormalizer {

    /**
     * Return MSIE String with the Major and Minor Version Only.
     *
     * @param userAgent
     * @return String
     */
    public String normalize(String userAgent) {
        if (userAgent.contains("MSIE")) {
            return msieWithVersion(userAgent);
        }
        return userAgent;
    }

    private String msieWithVersion(String userAgent) {
        int index = userAgent.indexOf("MSIE");
        return StringUtils.substring(userAgent, 0, index+9);
	}
	
}
