/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.specific;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * This Normalizer returns the user-agent unchanged.
 * 
 * @author Tommaso Teofili
 * 
 * @version $Id: NullNormalizer.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class NullNormalizer implements UserAgentNormalizer {

    public static final UserAgentNormalizer INSTANCE = new NullNormalizer();

    public String normalize(final String userAgent) {
		return userAgent;
	}

}
