/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.specific;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * This Normalizer returns Opera user agent with the major version.
 * 
 * e.g
 * <ul>
 * <li>
 * Opera/9.00 (Windows NT 5.1; U; de) -> Opera/9</li>
 * <li>
 * Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0) Opera 7.52 [en] -> Opera 7
 * </li>
 * </ul>
 * 
 * @author Tommaso Teofili
 * @author Filippo De Luca
 * 
 * @version $Id: OperaNormalizer.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class OperaNormalizer implements UserAgentNormalizer {

	public String normalize(String userAgent) {
		String normalized = userAgent;

		if (StringUtils.contains(userAgent, "Opera")) {
			int start = userAgent.indexOf("Opera");
			normalized = StringUtils.substring(userAgent, start, start + 7);

		}

		return normalized;
	}

}
