/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.request.normalizer.specific;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.text.StrBuilder;

import net.sourceforge.wurfl.core.request.normalizer.UserAgentNormalizer;

/**
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * @author Tommaso Teofili
 * 
 * @version $Id: SafariNormalizer.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class SafariNormalizer implements UserAgentNormalizer {
	
	private static final Pattern PATTERN = Pattern.compile("(Mozilla\\/5\\.0.*)(\\;\\s*U\\;.*?)(Safari\\/\\d{0,3})");
	

	/**
	 * Return the safari user agent stripping out 
	 * 	- all the chararcters between U; and Safari/xxx
	 *	
	 *  e.g Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_4_11; fr) AppleWebKit/525.18 (KHTML, like Gecko) Version/3.1.1 Safari/525.18
	 * 		becomes
	 * 		Mozilla/5.0 (Macintosh Safari/525
	 * 
	 * @param string $userAgent
	 * @return string
	 */
	public String normalize(String userAgent) {
		
		String normalized = userAgent;
		
		Matcher matcher = PATTERN.matcher(userAgent);
		
		if(matcher.find() && matcher.groupCount() >= 3) {
			StrBuilder normalizedBuilder = new StrBuilder();
			normalizedBuilder.append(matcher.group(1).trim()).append(" ").append(matcher.group(3).trim());
			
			normalized = normalizedBuilder.toString();
		}
		
		return normalized;
	}

}
