/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

/**
 * Bad capability position exception
 * 
 * <p>
 * This exception is thrown when a capability is defined in a different group in
 * which is defined by <code>generic</code>.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: BadCapabilityGroupException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class BadCapabilityGroupException extends CapabilityConsistencyException {

	/** serial */
	private static final long serialVersionUID = 10L;

	/** The bad group definig the capability */
	private String badGroup;

	/** The group must to define this capability */
	private String rightGroup;

	public BadCapabilityGroupException(ModelDevice device, String capability,
			String badGroup, String rightGroup) {
		super(device, capability, new StrBuilder("Capability: ").append(
				capability).append(" is defined in group: ").append(badGroup)
				.append(" istead in group:").append(rightGroup).append(
						" in Device: ").append(device.getID()).toString());

		this.rightGroup = rightGroup;
		this.badGroup = badGroup;
	}

	/**
	 * Return the identifier of group should defining the capability.
	 * 
	 * @return The identifier of right group.
	 */
	public String getRightGroup() {
		return rightGroup;
	}

	/**
	 * Return the group actually definig the capability.
	 * 
	 * @return The identifier of bad definig group.
	 */
	public String getBadGroup() {
		return badGroup;
	}

}
