/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

/**
 * Capability generic consistency exception
 * 
 * <p>
 * This is a abstract class representing all {@link DeviceConsistencyException}
 * regarding single capability.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: CapabilityConsistencyException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public abstract class CapabilityConsistencyException extends
		DeviceConsistencyException {

	/** Serial */
	private static final long serialVersionUID = 10L;

	/** The capability target of this Exception */
	private String capability;

	/**
	 * Build the Exception by devices and capability.
	 * 
	 * @param device
	 */
	public CapabilityConsistencyException(ModelDevice device, String capability) {
		super(device, new StrBuilder("Device: ").append(device.getID()).append(" Capability: ").append(capability).append(
		" consistency error").toString());
		
		this.capability = capability;
	}
	
	/**
	 * Build the Exception by devices and capability.
	 * 
	 * @param device
	 */
	public CapabilityConsistencyException(ModelDevice device, String capability, String message) {
		super(device, message);
		this.capability = capability;
	}

	/**
	 * Return the capability object of this Exception.
	 * 
	 * @return The identifier of the target capability.
	 */
	public String getCapability() {
		return capability;
	}

}
