/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import java.util.List;

import org.apache.commons.lang.text.StrBuilder;

import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * Circular hierarchy exception.
 * 
 * <p>
 * This Exception is thrown when is detected a ModelDevice member of a circular
 * hierarchy. A circular hierarchy don not have a start and a end device,
 * iterating over it take in a infinite loop.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: CircularHierarchyException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class CircularHierarchyException extends HierarchyConsistencyException {

	/** serial */
	private static final long serialVersionUID = 10L;

	/**
	 * Build this Exception by a hierarchy.
	 * 
	 * @param hierarchy
	 *            The list of {@link ModelDevice}s member of this circular
	 *            hierarchy.
	 */
	public CircularHierarchyException(List hierarchy) {
		super(hierarchy, new StrBuilder("Circular hierarchy detected: [ ")
				.append(StringUtils.hierarchyAsString(hierarchy)).append("]")
				.toString());

	}

}
