/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

/**
 * Device generic consistency exception.
 * 
 * <p>
 * This is abstract Exception representing an exception occurred for a
 * Consistency problem detected in a {@link ModelDevice} instance.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: DeviceConsistencyException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public abstract class DeviceConsistencyException extends
		WURFLConsistencyException {

	/** Serial */
	private static final long serialVersionUID = 10L;

	/** The ModelDevice object of this Exception */
	private ModelDevice device;

	/**
	 * Build an Exception from target ModelDevice and a message.
	 * 
	 * @param device
	 *            The ModelDevice object of this exception.
	 * @param message
	 *            The message printed by this exception.
	 */
	public DeviceConsistencyException(ModelDevice device, String message) {

		super(message);
		this.device = device;
	}

	/**
	 * Build an Exception from target ModelDevice.
	 * 
	 * @param device
	 *            The {@link ModelDevice} object of this exception.
	 */
	public DeviceConsistencyException(ModelDevice device) {

		super(new StrBuilder("Device: ").append(device.getID()).append(
		" consistency error").toString());
		this.device = device;
	}

	/**
	 * Return the ModelDevice source of this Exception.
	 * 
	 * @return The ModelDevice source of this Exception.
	 */
	public ModelDevice getDevice() {

		return device;
	}

}
