/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

import net.sourceforge.wurfl.core.WURFLRuntimeException;

/**
 * The device is not managed by model.
 * 
 * <p>
 * This exception is thrown if the referenced device is not managed by model.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: DeviceNotInModelException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class DeviceNotInModelException extends WURFLRuntimeException {

	/** serial */
	private static final long serialVersionUID = 10L;

	/** The unmanaged ModelDevice */
	private ModelDevice modelDevice;

	/**
	 * Build DeviceNotInModelException by source ModelDevice.
	 * 
	 * @param modelDevice
	 *            The exception source.
	 */
	public DeviceNotInModelException(ModelDevice modelDevice) {
		super(new StrBuilder("Device: ").append(modelDevice.getID()).append(
				" is not managed by model").toString());

		this.modelDevice = modelDevice;
	}

	/**
	 * Returns the held ModelDevice source of this exception.
	 * 
	 * @return Not defined ModelDevice.
	 */
	public ModelDevice getModelDevice() {
		return modelDevice;
	}

}
