/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

import net.sourceforge.wurfl.core.Constants;

/**
 * The device <i>generic</i> is not defined.
 * 
 * <p>
 * This Exception is thrown when the WURFLModel does not define the
 * <i>generic</i> device.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: GenericNotDefinedException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class GenericNotDefinedException extends WURFLConsistencyException {

	/** serial */
	private static final long serialVersionUID = 10L;

	/**
	 * Build this Exception.
	 */
	public GenericNotDefinedException() {
		super(new StrBuilder("Device: ").append(Constants.GENERIC).append(
				" is not defined").toString());
	}

}
