/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

/**
 * Generic group consistency exception.
 * 
 * <p>
 * This abstract Exception is thrown when a {@link ModelDevice} has a bad group
 * definition.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: GroupConsistencyException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public abstract class GroupConsistencyException extends
		DeviceConsistencyException {

	/** Serial */
	private static final long serialVersionUID = 10L;

	/** The group object of this Exception. */
	private String group;

	/**
	 * Build this Exception by Group identifier and source device.
	 * 
	 * @param device
	 *            The ModelDevice having bad group definition.
	 * @param group
	 *            The group object of this Exception.
	 */
	public GroupConsistencyException(ModelDevice device, String group) {

		super(device, new StrBuilder("Group: ").append(group).append(
				" in device: ").append(device.getID()).append(
				" consistency exception").toString());

		this.group = group;
	}

	/**
	 * Build this Exception by Group identifier, source device and message.
	 * 
	 * @param device
	 *            The ModelDevice having bad group definition.
	 * @param group
	 *            The group object of this Exception.
	 * @param message
	 *            The message displaying by this exception.
	 */
	public GroupConsistencyException(ModelDevice device, String group,
			String message) {
		super(device, message);

		this.group = group;

	}

	/**
	 * Return the group object of this exception.
	 * 
	 * @return Identifier of group object of this instance.
	 */
	public String getGroup() {
		return group;
	}

}
