/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

/**
 * Unknow capability exception.
 * 
 * <p>
 * This Exception is thrown when a {@link ModelDevice} define a capability not
 * defined by <code>generic</code> device.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: InexistentCapabilityException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class InexistentCapabilityException extends
		CapabilityConsistencyException {

	/** serial */
	private static final long serialVersionUID = 10L;

	/**
	 * Build this Exception from a {@link ModelDevice} and the not defined
	 * capability.
	 * 
	 * @param device
	 *            A {@link ModelDevice} instance defining capability.
	 * @param capability
	 *            The capability is not defined by <code>generic</code>
	 */
	public InexistentCapabilityException(ModelDevice device, String capability) {
		super(device, capability, new StrBuilder("Device: ").append(
				device.getID()).append(" define unknow capability: ").append(
				capability).toString());
	}

}
