/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

/**
 * Inexistent group exception.
 * 
 * <p>
 * This Exception is thrown when a {@link ModelDevice} define a group not
 * defined by <code>generic</code>.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: InexistentGroupException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class InexistentGroupException extends GroupConsistencyException {

	/** serial */
	private static final long serialVersionUID = 10L;

	/**
	 * Build the Exception from {@link ModelDevice} definig the group and the
	 * object group.
	 * 
	 * @param device
	 *            A {@link ModelDevice} defining the group.
	 * @param group
	 *            The group object of this Exception.
	 */
	public InexistentGroupException(ModelDevice device, String group) {
		super(device, group, new StrBuilder("Device: ").append(device.getID()).append(
		" define unknow group: ").append(group).toString());
	}

}
