/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import java.util.List;

import org.apache.commons.lang.text.StrBuilder;

import net.sourceforge.wurfl.core.utils.StringUtils;

/**
 * Orphan hierarchy exception
 * 
 * <p>
 * This Exception is thrown when a Hierarchy with null root is found.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: OrphanHierarchyException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class OrphanHierarchyException extends HierarchyConsistencyException {

	/** serial */
	private static final long serialVersionUID = 10L;

	/**
	 * Build exception by orphan hierarchy.
	 * 
	 * @param hierarchy
	 *            Detected orphan hierarchy.
	 */
	public OrphanHierarchyException(List hierarchy) {
		super(hierarchy, new StrBuilder("Orphan exception in hierarchy: [").append(
				StringUtils.hierarchyAsString(hierarchy)).append("]")
				.toString());
	}

}
