/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.core.io.Resource;

/**
 * Decorator of WURFLResource to build from Spring Resource.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: SpringResource.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public abstract class SpringResource implements WURFLResource {

	/** Delegate WURFLResource */
	protected WURFLResource delegate;

	/**
	 * Build resource from Spring Resource.
	 * 
	 * @param resource
	 *            The Spring Resource to build resource from.
	 */
	public SpringResource(Resource resource) {
		delegate = createDelegate(resource);
	}

	/**
	 * Create delegate WURFLResource from Spring Resource.
	 * 
	 * @param resource
	 *            The Spring Resource from that build WURFLResource.
	 * @return WURFLResource delegate.
	 */
	protected abstract WURFLResource createDelegate(Resource resource);

	// Delegate methods ***************************************************

	/**
	 * {@inheritDoc}
	 */
	public ResourceData getData() {
		return delegate.getData();
	}

	/**
	 * {@inheritDoc}
	 */
	public String getInfo() {
		return delegate.getInfo();
	}

	/**
	 * {@inheritDoc}
	 */
	public void release() {
		delegate.release();
	}

	// Commons methods ****************************************************

	public String toString() {
		return new ToStringBuilder(this).append(delegate).toString();
	}

	public int hashCode() {
		return new HashCodeBuilder().append(getClass()).append(delegate)
				.toHashCode();
	}

	public boolean equals(Object obj) {
		EqualsBuilder eb = new EqualsBuilder();

		eb.appendSuper(getClass().isInstance(obj));
		if (eb.isEquals()) {
			SpringXMLResource other = (SpringXMLResource) obj;
			eb.append(delegate, other.delegate);
		}

		return eb.isEquals();
	}

}