/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import java.io.IOException;

import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

/**
 * Subclass of SpringWURFLResource building XMLResource as delegate.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: SpringXMLResource.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class SpringXMLResource extends SpringResource implements WURFLResource {

	/**
	 * Build resource by Spring Resource
	 * 
	 * @param resource
	 *            Spring Resource
	 */
	public SpringXMLResource(Resource resource) {
		super(resource);
	}

	/**
	 * Create XMLREsource as delegate.
	 * 
	 * @param resource
	 *            The Resource to create delegate from.
	 * @return WURFLResource delegate.
	 */
	protected WURFLResource createDelegate(Resource resource) {

		try {
			
			if(resource instanceof InputStreamResource) {
				return new XMLResource(resource.getInputStream());
			}
			else{
				return new XMLResource(resource.getFile());
			}
		} catch (IOException e) {
			throw new WURFLResourceException(this, e);
		}

	}

}
