/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

/**
 * Generic User-Agent consistency exception.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: UserAgentConsistencyException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public abstract class UserAgentConsistencyException extends
		DeviceConsistencyException {

	/** Serial */
	private static final long serialVersionUID = 10L;

	/** User-Agent source of this exception */
	private String userAgent;

	/**
	 * Build UserAgentConsistencyException by device, userAgent and message.
	 * 
	 * @param device The device source of this exception.
	 * @param userAgent The user-agent causes consistency exception.
	 * @param message The message to display.
	 */
	public UserAgentConsistencyException(ModelDevice device, String userAgent,
			String message) {
		super(device, message);

		this.userAgent = userAgent;

	}

	/**
	 * Build UserAgentConsistencyException by device and userAgent.
	 * 
	 * @param device The device source of this exception.
	 * @param userAgent The user-agent causes consistency exception.
	 */
	public UserAgentConsistencyException(ModelDevice device, String userAgent) {
		super(device, new StrBuilder("Device: ").append(device.getID()).append(
				" user-agent: ").append(userAgent).append(
				" consistency exception").toString());

		this.userAgent = userAgent;
	}

	/**
	 * The inconsistent user-agent.
	 * 
	 * @return User-Agent string causes this exception.
	 */
	public String getUserAgent() {
		return userAgent;
	}

}
