/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

/**
 * User-Agent is not unique in model.
 * 
 * <p>
 * This exception is thrown when WURFL define two or more device with same
 * user-agent
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: UserAgentNotUniqueException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class UserAgentNotUniqueException extends UserAgentConsistencyException {

	/** serial */
	private static final long serialVersionUID = 10L;

	/** The device define target user-agent */
	private ModelDevice definingDevice;

	/**
	 * Build exception by source device, user-agent and device defines the
	 * user-agent.
	 * 
	 * @param device
	 *            The source device.
	 * @param userAgent
	 *            The non-unique user-agent.
	 * @param definingDevice
	 *            The source defining device.
	 */
	public UserAgentNotUniqueException(ModelDevice device, String userAgent,
			ModelDevice definingDevice) {
		super(device, userAgent, new StrBuilder("Device: ").append(device)
				.append(" define duplicate user-agent: ").append(userAgent)
				.append(" defined by device: ").append(definingDevice)
				.toString());

		this.definingDevice = definingDevice;
	}

	/**
	 * Returns the device defining the non-unique user-agent.
	 * 
	 * @return Defining device id.
	 */
	public ModelDevice getDefiningDevice() {
		return definingDevice;
	}

}
