/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

/**
 * User-Agent override exception.
 * 
 * <p>
 * This exception is thrown in case a patch try to override a user-agent defined
 * by a device.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: UserAgentOverrideException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class UserAgentOverrideException extends UserAgentConsistencyException {

	/** serial */
	private static final long serialVersionUID = 10L;

	/** The defined user-agent */
	private String existUserAgent;

	/**
	 * Build exception by source device, existing user-agent and overriding
	 * user-agent.
	 * 
	 * @param device
	 *            The source device.
	 * @param overridingUserAgent
	 *            The overriding user-agent.
	 * @param existUserAgent
	 *            The defined user-agent.
	 */
	public UserAgentOverrideException(ModelDevice device,
			String overridingUserAgent, String existUserAgent) {
		super(device, overridingUserAgent, new StrBuilder("Device: ").append(
				device).append(" override defined user-agent: ").append(
				existUserAgent).append(" with overriding user-agent:").append(
				overridingUserAgent).toString());

		this.existUserAgent = existUserAgent;
	}

	/**
	 * Return defined user-agent
	 * 
	 * @return The defined user-agent target of overriding.
	 */
	public String getExistUserAgent() {
		return existUserAgent;
	}

}
