/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

/**
 * This is a mutable {@link WURFLModel} interface. All classes need to modify
 * the model must referencing this interface.
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLAccessibleModel.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface WURFLAccessibleModel extends WURFLModel {

	/**
	 * Applies a patch to model runtime.
	 * 
	 * @param patch
	 *            The resource represents patch.
	 */
	void applyPatch(WURFLResource patch);

	/**
	 * Applies several patches to model runtime.
	 * 
	 * @param patches
	 *            The resources represent patches.
	 */
	void applyPatches(WURFLResources patches);

	// Event handling *****************************************************

	/**
	 * Add a {@link WURFLModelListener} observe this model.
	 * 
	 * @param The
	 *            listener to add.
	 */
	void addModelListener(WURFLModelListener listener);

	/**
	 * Remove a {@link WURFLModelListener} observing this model. If the listener
	 * are not observing this model then the operation is ignored.
	 * 
	 * @param The
	 *            listener to remove.
	 */
	void removeModelListener(WURFLModelListener listener);
}
