/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import net.sourceforge.wurfl.core.WURFLRuntimeException;

/**
 * WURFL generic consistency exception.
 * 
 * <p>
 * This exception is thrown when the WURFL model contains inconsistent data.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLConsistencyException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public abstract class WURFLConsistencyException extends WURFLRuntimeException {

	/** serial */
	private static final long serialVersionUID = 10L;
	
	/**
	 * Default constructor.
	 */
	public WURFLConsistencyException() {
		super("WURFL consistency exception");
	}

	/**
	 * Build WURFLConsistencyException by Throwable.
	 * 
	 * @param cause This exception cause.
	 */
	public WURFLConsistencyException(Throwable cause) {
		super("WURFL consistency exception", cause);
	}

	/**
	 * Build WURFLConsistencyException by displaying message.
	 * 
	 * @param message The message to display.
	 */
	public WURFLConsistencyException(String message) {
		super(message);
	}
	
	/**
	 * Build WURFLConsistencyException by Throwable and message.
	 * 
	 * @param cause This exception cause.
	 * @param message The message to display.
	 */
	public WURFLConsistencyException(String message, Throwable cause) {
		super(message, cause);
	}
}
