/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import net.sourceforge.wurfl.core.WURFLRuntimeException;

/**
 * Parsing exception.
 * 
 * <p>
 * Exception thrown when wurfl file and patch files contains invalid values.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLParsingException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class WURFLParsingException extends WURFLRuntimeException {

	/** serial */
	private static final long serialVersionUID = 10L;

	/**
	 * {@inheritDoc}
	 */
	public WURFLParsingException() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	public WURFLParsingException(String msg) {
		super(msg);
	}

	/**
	 * {@inheritDoc}
	 */
	public WURFLParsingException(Throwable cause) {
		super(cause);
	}

	/**
	 * {@inheritDoc}
	 */
	public WURFLParsingException(String msg, Throwable cause) {
		super(msg, cause);
	}

}
