/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;


/**
 * This interface represent a WURFL resource as the WURFL main file and a WURFL
 * patch file.
 * 
 * <p>
 * This interface provides a method to obtain data from physical resource as
 * File.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLResource.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public interface WURFLResource {

	/**
	 * Return ResourceData representing the data contained by the resource.
	 * 
	 * @return ResourceData instance
	 */
	ResourceData getData();

	/**
	 * Get info of this resource.
	 * 
	 * @return A String represent a info for this resource.
	 */
	String getInfo();

	/**
	 * Release the resource.
	 */
	void release();
}
