/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.resource;

import org.apache.commons.lang.text.StrBuilder;

import net.sourceforge.wurfl.core.WURFLRuntimeException;

/**
 * WURFLResource exception.
 * 
 * <p>
 * This exception is thrown whene there is a problem in WURFLResource.
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLResourceException.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class WURFLResourceException extends WURFLRuntimeException {

	/** serial */
	private static final long serialVersionUID = 10L;

	/** The exception source */
	private WURFLResource resource;

	/**
	 * Build a WURFLResourceException by WURFLResource.
	 * 
	 * @param resource
	 *            The WURFLResource generated this exception.
	 */
	public WURFLResourceException(WURFLResource resource) {

		super(new StrBuilder("WURFL resource exception in: ").append(
				resource.getInfo()).toString());
		this.resource = resource;
	}

	/**
	 * Build a WURFLResourceException by WURFLResource.
	 * 
	 * @param resource
	 *            The WURFLResource generated this exception.
	 * @param cause
	 *            The exception causes this exception.
	 */
	public WURFLResourceException(WURFLResource resource, Throwable cause) {

		super(cause);
		this.resource = resource;
	}

	/**
	 * Build a WURFLResourceException by WURFLResource.
	 * 
	 * @param resource
	 *            The WURFLResource generated this exception.
	 * @param message
	 *            The message to display.
	 */
	public WURFLResourceException(WURFLResource resource, String message) {

		super(message);
		this.resource = resource;
	}

	/**
	 * Build a WURFLResourceException by WURFLResource.
	 * 
	 * @param resource
	 *            The WURFLResource generated this exception.
	 * @param message
	 *            The message to display.
	 * @param cause
	 *            The exception causes this exception.
	 */
	public WURFLResourceException(WURFLResource resource, String message,
			Throwable cause) {

		super(message, cause);
		this.resource = resource;
	}

	/**
	 * Returns the WURFLResource sorce of this exception.
	 * 
	 * @return WURFLResource causes this exception.
	 */
	public WURFLResource getResource() {
		return resource;
	}

}
