/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.utils;

import org.apache.commons.collections.Predicate;

/**
 * @author: Fantayeneh Asres Gizaw
 */
public final class Predicates {
    private Predicates() {
    }

    public static Predicate isContainedIn(final String string) {
        return new IsContainedIn(string);
    }

    public static Predicate startsWith(String s) {
        return new StartsWith(s);
    }


    private static class IsContainedIn implements Predicate {

        private final String userAgent;

        private IsContainedIn(String userAgent) {
            this.userAgent = userAgent;
        }

        public boolean evaluate(Object object) {
            return org.apache.commons.lang.StringUtils.contains(userAgent, (String) object);
        }
    }

    private static class StartsWith implements Predicate {
        private final String s;

        public StartsWith(String s) {
            this.s = s;
        }

        public boolean evaluate(Object object) {
            return object != null && object.toString().startsWith(s);
        }
    }


}
