/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

package net.sourceforge.wurfl.core.utils;


import java.util.Enumeration;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.Validate;

public final class RequestUtils {

    private RequestUtils() {}
    
	public static boolean containsHeader(HttpServletRequest request, String match){
		
		Validate.notNull(request, "The request is null");
		Validate.notEmpty(match, "The match is empty");
		
		Enumeration headers = request.getHeaderNames();
		Iterator hIt = IteratorUtils.asIterator(headers);
		
		while(hIt.hasNext()){
			String header = (String)hIt.next();
			if(org.apache.commons.lang.StringUtils.contains(header, match)){
				return true;
			}
		}
		
		return false;

	}

}
