/**
 * This file is released under the GNU General Public License.
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2010 WURFL-Pro srl
 */

/* $Id: WURFLServletContextListener.java 432 2010-05-06 12:12:53Z filippo.deluca $ 
 * This file is released under the GNU General Public License. 
 * Refer to the COPYING file distributed with this package.
 *
 * Copyright (c) 2008-2009 WURFL-Pro S.r.l.
 */
package net.sourceforge.wurfl.core.web;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.commons.lang.StringUtils;

import net.sourceforge.wurfl.core.WURFLHolder;

/**
 * ServletContextListener instantiating WURFLHolder.
 * 
 * <p>
 * This class permit to instantiate WURFL at servlet context loading time:
 * 
 * <pre>
 *  &lt;web-app version=&quot;2.4&quot; xmlns=&quot;http://java.sun.com/xml/ns/j2ee&quot;
 *  xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot;
 *  xsi:schemaLocation=&quot;http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd&quot;&gt;
 * 
 * 	&lt;context-param&gt;
 * 		&lt;param-name&gt;wurfl&lt;/param-name&gt;
 * 		&lt;param-value&gt;/WEB-INF/wurfl.zip&lt;/param-value&gt;
 * 	&lt;/context-param&gt;
 * 	
 *  &lt;context-param&gt;
 * 		&lt;param-name&gt;wurflPatch&lt;/param-name&gt;
 * 		&lt;param-value&gt;/WEB-INF/wb_patch.xml,/WEB-INF/other_patch.xml&lt;/param-value&gt;
 * 	&lt;/context-param&gt;
 * 
 * 	&lt;context-param&gt; 
 * 		&lt;param-name&gt;wurflLazy&lt;/param-name&gt;
 * 		&lt;param-value&gt;true&lt;/param-value&gt;
 * 	&lt;/context-param&gt;
 * 
 * 	&lt;!-- the ServletContext key against store the wurflHolder. This is default --&gt; 
 * 	&lt;context-param&gt; 
 * 		&lt;param-name&gt;wurflHolderKey&lt;/param-name&gt;
 * 		&lt;param-value&gt;net.sourceforge.wurfl.core.WURFLHolder&lt;/param-value&gt;
 * 	&lt;/context-param&gt;
 * 
 * 	&lt;listener&gt;
 * 		&lt;listener-class&gt;
 * 		net.sourceforge.wurfl.core.web.WURFLServletContextListener 
 * 		&lt;/listener-class&gt;
 * 	&lt;/listener&gt;
 * 
 *  &lt;/web-app&gt;
 * </pre>
 * 
 * </p>
 * 
 * @author Fantayeneh Asres Gizaw
 * @author Filippo De Luca
 * 
 * @version $Id: WURFLServletContextListener.java 432 2010-05-06 12:12:53Z filippo.deluca $
 */
public class WURFLServletContextListener implements ServletContextListener {

	/** Servlet context parameter contains the name of WURFLHolder parameter */
	public static final String WURFL_HOLDER_KEY_PARAM = "wurflHolderKey";

	/**
	 * Default WURFLHolder key: net.sourceforge.wurfl.core.WURFLHolder
	 */
	public static final String WURFL_HOLDER_KEY = WURFLHolder.class.getName();

	/** WURFLHolder ServletContext attribute name */
	private String wurflHolderContextKey = WURFL_HOLDER_KEY;

	public void contextInitialized(ServletContextEvent servletContextEvent) {
		ServletContext servletContext = servletContextEvent.getServletContext();

		wurflHolderContextKey = servletContextEvent.getServletContext()
				.getInitParameter(WURFL_HOLDER_KEY_PARAM);
		if (StringUtils.isEmpty(wurflHolderContextKey)) {
			wurflHolderContextKey = WURFL_HOLDER_KEY;
		}

		ServletContextWURFLHolder wurflHolder = new ServletContextWURFLHolder(servletContext);

		servletContext.setAttribute(wurflHolderContextKey, wurflHolder);

	}

	public void contextDestroyed(ServletContextEvent servletContextEvent) {

		ServletContext servletContext = servletContextEvent.getServletContext();

		servletContext.removeAttribute(wurflHolderContextKey);

	}

}
