/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.configured;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.stickycode.configured.ConfiguredFieldProcessor;
import net.stickycode.metadata.MetadataResolverRegistry;
import net.stickycode.reflector.AnnotationFinder;
import net.stickycode.stereotype.StickyComponent;
import net.stickycode.stereotype.StickyFramework;
import net.stickycode.stereotype.configured.PostConfigured;
import net.stickycode.stereotype.configured.PreConfigured;
import org.slf4j.LoggerFactory;

@StickyComponent
@StickyFramework
public class ConfiguredMetadata {
    private static Class<? extends Annotation>[] configuredAnnotations;
    private static Class<? extends Annotation>[] configuredLifecycleAnnotations;
    private static Map<Class<? extends Annotation>, Method> defaultSeeds;
    @Inject
    MetadataResolverRegistry metdataResolverRegistry;

    public Class<? extends Annotation>[] getConfiguredAnnotations() {
        return configuredAnnotations;
    }

    public Class<? extends Annotation>[] getConfiguredLifecycleAnnotations() {
        return configuredLifecycleAnnotations;
    }

    public Map<Class<? extends Annotation>, Method> getDefaultSeeds() {
        return defaultSeeds;
    }

    public boolean typeIsConfigured(Class<?> type) {
        if (this.metdataResolverRegistry.does(type).haveAnyFieldsMetaAnnotatedWith((Class[])this.getConfiguredAnnotations())) {
            return true;
        }
        return this.metdataResolverRegistry.does(type).haveAnyMethodsMetaAnnotatedWith((Class[])this.getConfiguredLifecycleAnnotations());
    }

    static {
        configuredLifecycleAnnotations = new Class[]{PreConfigured.class, PostConfigured.class};
        defaultSeeds = new HashMap<Class<? extends Annotation>, Method>();
        configuredAnnotations = AnnotationFinder.load((String)"co.nfigured", (String)"configured");
        LoggerFactory.getLogger(ConfiguredFieldProcessor.class).info("configuring with {}", (Object[])configuredAnnotations);
        for (Class<? extends Annotation> type : configuredAnnotations) {
            try {
                Method defaultValue = type.getDeclaredMethod("defaultValue", new Class[0]);
                if (!String.class.isAssignableFrom(defaultValue.getReturnType())) continue;
                defaultSeeds.put(type, defaultValue);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

