/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import org.apache.commons.javaflow.providers.asm5.ComputeClassWriter;
import org.apache.commons.javaflow.providers.asm5.ContinuableClassVisitor;
import org.apache.commons.javaflow.spi.ContinuableClassInfoResolver;
import org.apache.commons.javaflow.spi.ResourceTransformer;
import org.apache.commons.javaflow.spi.StopException;
import org.objectweb.asm.ClassReader;

final class Asm5ClassTransformer
implements ResourceTransformer {
    private final ContinuableClassInfoResolver cciResolver;

    Asm5ClassTransformer(ContinuableClassInfoResolver cciResolver) {
        this.cciResolver = cciResolver;
    }

    @Override
    public byte[] transform(byte[] original) {
        ComputeClassWriter cw = new ComputeClassWriter(2, this.cciResolver.resourceLoader());
        ContinuableClassVisitor visitor = new ContinuableClassVisitor(cw, this.cciResolver, original);
        try {
            new ClassReader(original).accept(visitor, 4);
        }
        catch (StopException ex) {
            return null;
        }
        if (visitor.skipEnchancing()) {
            return null;
        }
        byte[] bytecode = cw.toByteArray();
        return bytecode;
    }
}

