/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import org.apache.commons.javaflow.providers.asm5.Asm5ContinuableClassInfoResolver;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;

public class MaybeContinuableAnnotationVisitor
extends ClassVisitor {
    private final Asm5ContinuableClassInfoResolver environment;
    private boolean classContinuableAnnotationFound = false;
    private boolean isAnnotation = false;

    public MaybeContinuableAnnotationVisitor(Asm5ContinuableClassInfoResolver environment) {
        super(327680);
        this.environment = environment;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isAnnotation = (access & 0x2000) > 0;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String description, boolean visible) {
        if (this.isAnnotation && !this.classContinuableAnnotationFound) {
            this.classContinuableAnnotationFound = this.environment.isContinuableAnnotation(description);
        }
        return null;
    }

    boolean isContinuable() {
        return this.classContinuableAnnotationFound && this.isAnnotation;
    }
}

