/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.commons.javaflow.spi.ClasspathResourceLoader;
import org.apache.commons.javaflow.spi.ResourceTransformationFactory;
import org.apache.commons.javaflow.spi.ResourceTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RewritingUtils {
    private static final Log log = LogFactory.getLog(RewritingUtils.class);
    private static final Matcher MATCH_ALL = new Matcher(){

        public boolean isMatching(String pName) {
            return true;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rewriteClassFile(File pInput, ResourceTransformer transformer, File pOutput) throws IOException {
        byte[] original = RewritingUtils.toByteArray(pInput);
        byte[] transformed = transformer.transform(original);
        if (transformed != original || !pOutput.equals(pInput)) {
            FileOutputStream os = new FileOutputStream(pOutput);
            try {
                os.write(transformed);
            }
            finally {
                os.close();
            }
            return true;
        }
        return false;
    }

    public static boolean rewriteJar(JarInputStream pInput, ResourceTransformer transformer, JarOutputStream pOutput) throws IOException {
        return RewritingUtils.rewriteJar(pInput, transformer, pOutput, MATCH_ALL);
    }

    public static boolean rewriteJar(JarInputStream pInput, ResourceTransformer transformer, JarOutputStream pOutput, Matcher pMatcher) throws IOException {
        JarEntry entry;
        boolean changed = false;
        while ((entry = pInput.getNextJarEntry()) != null) {
            if (entry.isDirectory()) {
                pOutput.putNextEntry(new JarEntry(entry));
                continue;
            }
            String name = entry.getName();
            pOutput.putNextEntry(new JarEntry(name));
            if (name.endsWith(".class")) {
                if (pMatcher.isMatching(name)) {
                    if (log.isDebugEnabled()) {
                        log.debug("transforming " + name);
                    }
                    byte[] original = RewritingUtils.toByteArray(pInput);
                    byte[] transformed = transformer.transform(original);
                    pOutput.write(transformed);
                    changed |= transformed.length != original.length;
                    continue;
                }
            } else if (name.endsWith(".jar") || name.endsWith(".ear") || name.endsWith(".zip") || name.endsWith(".war")) {
                changed |= RewritingUtils.rewriteJar(new JarInputStream(pInput), transformer, new JarOutputStream(pOutput), pMatcher);
                continue;
            }
            int length = RewritingUtils.copy(pInput, pOutput);
            log.debug("copied " + name + "(" + length + ")");
        }
        pInput.close();
        pOutput.close();
        return changed;
    }

    public static byte[] toByteArray(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            byte[] byArray = RewritingUtils.toByteArray(in);
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RewritingUtils.copy(in, baos);
        return baos.toByteArray();
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        int total = 0;
        while ((n = in.read(buf)) >= 0) {
            out.write(buf, 0, n);
            total += n;
        }
        return total;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        ResourceTransformationFactory factory = RewritingUtils.createTransformerFactoryInstance();
        for (int i = 0; i < args.length; i += 2) {
            System.out.println("rewriting " + args[i]);
            ResourceTransformer transformer = RewritingUtils.createTransformer(new URL[]{new File(args[i]).toURI().toURL()}, factory);
            RewritingUtils.rewriteJar(new JarInputStream(new FileInputStream(args[i])), transformer, new JarOutputStream(new FileOutputStream(args[i + 1])));
        }
        System.out.println("done");
    }

    public static ResourceTransformer createTransformer(URL[] extraURL) {
        return RewritingUtils.createTransformer(extraURL, RewritingUtils.createTransformerFactoryInstance());
    }

    public static ResourceTransformer createTransformer(URL[] extraURL, TransformerType type) {
        return RewritingUtils.createTransformer(extraURL, RewritingUtils.createTransformerFactoryInstance(type));
    }

    public static ResourceTransformer createTransformer(URL[] extraURL, ResourceTransformationFactory factory) {
        URLClassLoader classLoader = new URLClassLoader(extraURL, RewritingUtils.safeParentClassLoader());
        final ResourceTransformer transformerDelegate = factory.createTransformer(factory.createResolver(new ClasspathResourceLoader(classLoader)));
        return new ResourceTransformer(){

            public byte[] transform(byte[] original) {
                byte[] transformed = transformerDelegate.transform(original);
                return null != transformed ? transformed : original;
            }
        };
    }

    private static final ClassLoader safeParentClassLoader() {
        ClassLoader ownClassLoader = RewritingUtils.class.getClassLoader();
        return null == ownClassLoader ? ClassLoader.getSystemClassLoader() : ownClassLoader;
    }

    public static ResourceTransformationFactory createTransformerFactoryInstance() {
        return RewritingUtils.createTransformerFactoryInstance(null);
    }

    public static ResourceTransformationFactory createTransformerFactoryInstance(TransformerType transformerType) {
        Class<? extends ResourceTransformationFactory> transformerFactoryClass;
        if (null == transformerType) {
            transformerFactoryClass = RewritingUtils.getDefaultResourceTransformerFactoryClass();
        } else {
            try {
                transformerFactoryClass = transformerType.implementaion();
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            return transformerFactoryClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<? extends ResourceTransformationFactory> getDefaultResourceTransformerFactoryClass() {
        for (TransformerType transformerType : TransformerType.values()) {
            try {
                return transformerType.implementaion();
            }
            catch (ClassNotFoundException ex) {
                System.err.println(ex);
            }
        }
        throw new RuntimeException("No bytecode transformation class is found for JavaFlow bytecode modifications");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransformerType {
        ASM5("org.apache.commons.javaflow.providers.asm5.Asm5ResourceTransformationFactory"),
        ASM4("org.apache.commons.javaflow.providers.asm4.Asm4ResourceTransformationFactory"),
        ASM3("org.apache.commons.javaflow.providers.asm3.Asm3ResourceTransformationFactory"),
        BCEL("org.apache.commons.javaflow.providers.bcel.BcelResourceTransformationFactory");

        private final String implementation;

        private TransformerType(String implementation) {
            this.implementation = implementation;
        }

        Class<? extends ResourceTransformationFactory> implementaion() throws ClassNotFoundException {
            Class<?> c = Class.forName(this.implementation);
            return c;
        }
    }

    public static interface Matcher {
        public boolean isMatching(String var1);
    }
}

