/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.xunit;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.thucydides.core.reports.adaptors.xunit.CouldNotReadXUnitFileException;
import net.thucydides.core.reports.adaptors.xunit.XUnitLoader;
import net.thucydides.core.reports.adaptors.xunit.model.TestCase;
import net.thucydides.core.reports.adaptors.xunit.model.TestException;
import net.thucydides.core.reports.adaptors.xunit.model.TestSuite;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicXUnitLoader
implements XUnitLoader {
    @Override
    public List<TestSuite> loadFrom(File xUnitReport) throws IOException {
        ArrayList testSuites = Lists.newArrayList();
        Document doc = this.parseDocument(xUnitReport);
        NodeList testSuiteElements = doc.getElementsByTagName("testsuite");
        this.shouldHaveAtLeastOneTestSuite(testSuiteElements, xUnitReport);
        for (int i = 0; i < testSuiteElements.getLength(); ++i) {
            Optional<TestSuite> testSuite = this.testSuiteFrom(testSuiteElements.item(i));
            testSuites.addAll(testSuite.asSet());
        }
        return testSuites;
    }

    private void shouldHaveAtLeastOneTestSuite(NodeList testSuiteElements, File xUnitReport) {
        if (testSuiteElements.getLength() == 0) {
            throw new CouldNotReadXUnitFileException("Could not read xUnit file " + xUnitReport.getAbsolutePath());
        }
    }

    private Optional<TestSuite> testSuiteFrom(Node testSuiteNode) {
        Element testSuiteElement = (Element)testSuiteNode;
        TestSuite testSuite = TestSuite.named(testSuiteElement.getAttribute("name"));
        List<TestCase> testCases = this.testCasesFrom(testSuiteElement);
        return Optional.of((Object)testSuite.withTestCases(testCases));
    }

    private List<TestCase> testCasesFrom(Element testSuiteElement) {
        NodeList testCaseElements = testSuiteElement.getElementsByTagName("testcase");
        ArrayList testCases = Lists.newArrayList();
        for (int i = 0; i < testCaseElements.getLength(); ++i) {
            testCases.add(this.testCaseFrom(testCaseElements.item(i)));
        }
        return testCases;
    }

    private TestCase testCaseFrom(Node item) {
        String skipped;
        Optional<TestException> error;
        Element testCaseElement = (Element)item;
        TestCase testCase = this.getBasicTestCaseFrom(testCaseElement);
        Optional<TestException> failure = this.exceptionElementIn(testCaseElement).ofType("failure");
        if (failure.isPresent()) {
            testCase = testCase.withFailure((TestException)failure.get());
        }
        if ((error = this.exceptionElementIn(testCaseElement).ofType("error")).isPresent()) {
            testCase = testCase.withError((TestException)error.get());
        }
        if (StringUtils.isNotEmpty((CharSequence)(skipped = this.skippedTextIn(testCaseElement)))) {
            testCase = testCase.wasSkipped(skipped);
        }
        return testCase;
    }

    private String skippedTextIn(Element testCaseElement) {
        String skipMessage = "";
        NodeList skipElements = testCaseElement.getElementsByTagName("skipped");
        if (skipElements.getLength() > 0) {
            skipMessage = ((Element)skipElements.item(0)).getAttribute("type");
        }
        return skipMessage;
    }

    private TestCase getBasicTestCaseFrom(Element testCaseElement) {
        String name = testCaseElement.getAttribute("name");
        String classname = testCaseElement.getAttribute("classname");
        double timeValue = this.timeFrom(testCaseElement);
        return TestCase.withName(name).andClassname(classname).andTime(timeValue);
    }

    private ExceptionElementBuilder exceptionElementIn(Element testCaseElement) {
        return new ExceptionElementBuilder(testCaseElement);
    }

    private double timeFrom(Element testCaseElement) {
        String time = testCaseElement.getAttribute("time");
        double timeValue = 0.0;
        if (StringUtils.isNotEmpty((CharSequence)time)) {
            timeValue = Double.parseDouble(time);
        }
        return timeValue;
    }

    private Document parseDocument(File xUnitReport) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(xUnitReport);
        }
        catch (Exception e) {
            throw new CouldNotReadXUnitFileException(e.getMessage());
        }
    }

    private class ExceptionElementBuilder {
        private final Element testCaseElement;

        public ExceptionElementBuilder(Element testCaseElement) {
            this.testCaseElement = testCaseElement;
        }

        public Optional<TestException> ofType(String exceptionType) {
            NodeList failureElements = this.testCaseElement.getElementsByTagName(exceptionType);
            if (failureElements.getLength() > 0) {
                Element failureElement = (Element)failureElements.item(0);
                String message = failureElement.getAttribute("message");
                String errorOutput = failureElement.getTextContent();
                return Optional.of((Object)new TestException(message, errorOutput, exceptionType));
            }
            return Optional.absent();
        }
    }
}

