/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import net.thucydides.core.requirements.ChildrenFirstOrderedMap;
import net.thucydides.core.requirements.Req;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequirementPersister {
    private final Logger logger = LoggerFactory.getLogger(RequirementPersister.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final File outputDirectory;
    private final String rootDirectory;

    public RequirementPersister(File outputDirectory, String rootDirectory) {
        this.outputDirectory = outputDirectory;
        this.rootDirectory = rootDirectory;
    }

    public SortedMap<String, Req> read() {
        ChildrenFirstOrderedMap map = new ChildrenFirstOrderedMap();
        try {
            MapType type = this.mapper.getTypeFactory().constructMapType(map.getClass(), String.class, Req.class);
            File jsonFile = new File(this.outputDirectory, this.rootDirectory + ".json");
            if (!jsonFile.exists()) {
                return map;
            }
            SortedMap m = (SortedMap)this.mapper.readValue(jsonFile, (JavaType)type);
            map.putAll(m);
            for (Map.Entry entry : m.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.contains(".")) continue;
                String parent = key.substring(0, key.lastIndexOf("."));
                this.addChildIfNotPresent((Req)map.get(parent), (Req)entry.getValue());
            }
        }
        catch (IOException e) {
            this.logger.error("Error while reading requirements from output directory: " + this.outputDirectory + " ,file: " + this.rootDirectory + ".json", (Throwable)e);
        }
        return map;
    }

    private void addChildIfNotPresent(Req req, Req child) {
        if (!req.getChildren().contains(child)) {
            req.getChildren().add(child);
        }
    }

    public void write(SortedMap<String, Req> map) {
        try {
            FileOutputStream os = new FileOutputStream(new File(this.outputDirectory, this.rootDirectory + ".json"));
            this.mapper.writeValue((OutputStream)os, map);
            os.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

