/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.thucydides.core.csv.CSVTestDataSource;
import net.thucydides.core.csv.TestDataSource;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.steps.DataDrivenStepFactory;
import net.thucydides.core.steps.FilePathParser;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.util.EnvironmentVariables;

public final class StepData {
    private final String testDataSource;
    private char separator = (char)44;
    private StepFactory factory;
    private static final ThreadLocal<StepFactory> factoryThreadLocal = new ThreadLocal();

    public StepData(String testDataSource) {
        FilePathParser testDataSourcePath = new FilePathParser((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
        this.testDataSource = testDataSourcePath.getInstanciatedPath(testDataSource);
    }

    public static StepData withTestDataFrom(String testDataSource) {
        return new StepData(testDataSource);
    }

    public <T> T run(T steps) throws IOException {
        this.useDefaultStepFactoryIfUnassigned();
        CSVTestDataSource testdata = new CSVTestDataSource(this.testDataSource, this.separator);
        StepEventBus.getEventBus().useExamplesFrom(this.dataTable(testdata));
        Class<?> scenarioStepsClass = steps.getClass().getSuperclass();
        List<?> instanciatedSteps = testdata.getInstanciatedInstancesFrom(scenarioStepsClass, this.factory);
        DataDrivenStepFactory dataDrivenStepFactory = new DataDrivenStepFactory(this.factory);
        Object stepsProxy = dataDrivenStepFactory.newDataDrivenSteps(scenarioStepsClass, instanciatedSteps);
        return (T)stepsProxy;
    }

    private DataTable dataTable(TestDataSource testdata) {
        return DataTable.withHeaders(testdata.getHeaders()).andRows(this.rowsFrom(testdata)).build();
    }

    private List<List<Object>> rowsFrom(TestDataSource testdata) {
        ArrayList rows = Lists.newArrayList();
        for (Map<String, String> rowData : testdata.getData()) {
            ArrayList row = Lists.newArrayList();
            for (String header : testdata.getHeaders()) {
                row.add(rowData.get(header));
            }
            rows.add(row);
        }
        return rows;
    }

    private void useDefaultStepFactoryIfUnassigned() {
        if (this.factory == null) {
            this.factory = StepData.getDefaultStepFactory();
        }
    }

    public StepData usingFactory(StepFactory factory) {
        this.factory = factory;
        return this;
    }

    public static void setDefaultStepFactory(StepFactory factory) {
        factoryThreadLocal.set(factory);
    }

    public static StepFactory getDefaultStepFactory() {
        if (factoryThreadLocal.get() == null) {
            factoryThreadLocal.set(new StepFactory());
        }
        return factoryThreadLocal.get();
    }

    public StepData separatedBy(char newSeparator) {
        this.separator = newSeparator;
        return this;
    }
}

