/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.gargoylesoftware.htmlunit.ScriptException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.core.webdriver.stubs.NavigationStub;
import net.thucydides.core.webdriver.stubs.OptionsStub;
import net.thucydides.core.webdriver.stubs.TargetLocatorStub;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFacade
implements WebDriver,
TakesScreenshot,
HasInputDevices,
JavascriptExecutor {
    private final Class<? extends WebDriver> driverClass;
    private final WebDriverFactory webDriverFactory;
    protected WebDriver proxiedWebDriver;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFacade.class);

    public WebDriverFacade(Class<? extends WebDriver> driverClass, WebDriverFactory webDriverFactory) {
        this.driverClass = driverClass;
        this.webDriverFactory = webDriverFactory;
    }

    public Class<? extends WebDriver> getDriverClass() {
        return this.driverClass;
    }

    public WebDriver getProxiedDriver() {
        if (this.proxiedWebDriver == null) {
            this.proxiedWebDriver = this.newProxyDriver();
            WebdriverProxyFactory.getFactory().notifyListenersOfWebdriverCreationIn(this);
        }
        return this.proxiedWebDriver;
    }

    public boolean isEnabled() {
        return !StepEventBus.getEventBus().webdriverCallsAreSuspended();
    }

    public void reset() {
        if (this.proxiedWebDriver != null) {
            this.forcedQuit();
        }
        this.proxiedWebDriver = null;
    }

    private void forcedQuit() {
        try {
            this.getDriverInstance().quit();
            this.proxiedWebDriver = null;
        }
        catch (WebDriverException e) {
            LOGGER.warn("Closing a driver that was already closed: " + e.getMessage());
        }
    }

    protected WebDriver newProxyDriver() {
        return this.newDriverInstance();
    }

    private WebDriver newDriverInstance() {
        try {
            this.webDriverFactory.setupFixtureServices();
            return this.webDriverFactory.newWebdriverInstance(this.driverClass);
        }
        catch (UnsupportedDriverException e) {
            LOGGER.error("FAILED TO CREATE NEW DRIVER INSTANCE " + this.driverClass + ": " + e.getMessage(), (Throwable)e);
            throw new UnsupportedDriverException("Could not instantiate " + this.driverClass, e);
        }
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        if (this.proxyInstanciated() && this.driverCanTakeScreenshots()) {
            try {
                return (X)((TakesScreenshot)this.getProxiedDriver()).getScreenshotAs(target);
            }
            catch (WebDriverException e) {
                LOGGER.warn("Failed to take screenshot - driver closed already? (" + e.getMessage() + ")");
            }
            catch (OutOfMemoryError outOfMemoryError) {
                LOGGER.error("Failed to take screenshot - out of memory", (Throwable)outOfMemoryError);
            }
        }
        return null;
    }

    private boolean driverCanTakeScreenshots() {
        return TakesScreenshot.class.isAssignableFrom(this.getProxiedDriver().getClass());
    }

    public void get(String url) {
        if (!this.isEnabled()) {
            return;
        }
        this.openIgnoringHtmlUnitScriptErrors(url);
    }

    private void openIgnoringHtmlUnitScriptErrors(String url) {
        block2: {
            try {
                this.getProxiedDriver().get(url);
            }
            catch (WebDriverException e) {
                if (this.htmlunitScriptError(e)) break block2;
                throw e;
            }
        }
    }

    private boolean htmlunitScriptError(WebDriverException e) {
        if (e.getCause() != null && e.getCause() instanceof ScriptException) {
            LOGGER.warn("Ignoring HTMLUnit script error: " + e.getMessage());
            return true;
        }
        return false;
    }

    public String getCurrentUrl() {
        if (!this.isEnabled()) {
            return "";
        }
        return this.getProxiedDriver().getCurrentUrl();
    }

    public String getTitle() {
        if (!this.isEnabled()) {
            return "";
        }
        return this.getProxiedDriver().getTitle();
    }

    public List<WebElement> findElements(By by) {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        return this.getProxiedDriver().findElements(by);
    }

    public WebElement findElement(By by) {
        if (!this.isEnabled()) {
            throw new ElementNotVisibleException("No element found for " + by.toString() + " (a previous step has failed)");
        }
        return this.getProxiedDriver().findElement(by);
    }

    public String getPageSource() {
        if (!this.isEnabled()) {
            return "";
        }
        return this.getProxiedDriver().getPageSource();
    }

    protected WebDriver getDriverInstance() {
        return this.proxiedWebDriver;
    }

    public void close() {
        if (this.proxyInstanciated()) {
            if (this.getDriverInstance().getWindowHandles() != null && this.getDriverInstance().getWindowHandles().size() == 1) {
                this.quit();
            } else {
                this.getDriverInstance().close();
            }
            this.webDriverFactory.shutdownFixtureServices();
        }
    }

    public void quit() {
        if (this.proxyInstanciated()) {
            try {
                this.getDriverInstance().quit();
            }
            catch (WebDriverException e) {
                LOGGER.warn("Error while quitting the driver (" + e.getMessage() + ")");
            }
            this.proxiedWebDriver = null;
        }
    }

    protected boolean proxyInstanciated() {
        return this.getDriverInstance() != null;
    }

    public Set<String> getWindowHandles() {
        if (!this.isEnabled()) {
            return new HashSet<String>();
        }
        return this.getProxiedDriver().getWindowHandles();
    }

    public String getWindowHandle() {
        if (!this.isEnabled()) {
            return "";
        }
        return this.getProxiedDriver().getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        if (!this.isEnabled()) {
            return new TargetLocatorStub(this);
        }
        return this.getProxiedDriver().switchTo();
    }

    public WebDriver.Navigation navigate() {
        if (!this.isEnabled()) {
            return new NavigationStub();
        }
        return this.getProxiedDriver().navigate();
    }

    public WebDriver.Options manage() {
        if (!this.isEnabled()) {
            return new OptionsStub();
        }
        return this.getProxiedDriver().manage();
    }

    public boolean canTakeScreenshots() {
        return this.driverClass != null && (TakesScreenshot.class.isAssignableFrom(this.driverClass) || this.driverClass == RemoteWebDriver.class);
    }

    public boolean isInstantiated() {
        return this.driverClass != null && this.proxiedWebDriver != null;
    }

    public Keyboard getKeyboard() {
        return ((HasInputDevices)this.getProxiedDriver()).getKeyboard();
    }

    public Mouse getMouse() {
        return ((HasInputDevices)this.getProxiedDriver()).getMouse();
    }

    public Object executeScript(String script, Object ... parameters) {
        return ((JavascriptExecutor)this.getProxiedDriver()).executeScript(script, parameters);
    }

    public Object executeAsyncScript(String script, Object ... parameters) {
        return ((JavascriptExecutor)this.getProxiedDriver()).executeAsyncScript(script, parameters);
    }
}

