/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.model.Example;
import net.thucydides.core.requirements.model.RequirementBuilderNameStep;

public class Requirement
implements Comparable {
    private String displayName;
    private String name;
    private String type;
    private String narrativeText;
    private String cardNumber;
    private List<Requirement> children;
    private List<Example> examples;
    private List<String> releaseVersions;

    public Requirement() {
    }

    protected Requirement(String name, String displayName, String cardNumber, String type, String narrativeText, List<Requirement> children, List<Example> examples, List<String> releaseVersions) {
        this.name = name;
        this.displayName = displayName;
        this.cardNumber = cardNumber;
        this.type = type;
        this.narrativeText = narrativeText;
        this.children = ImmutableList.copyOf(children);
        this.examples = ImmutableList.copyOf(examples);
        this.releaseVersions = ImmutableList.copyOf(releaseVersions);
    }

    protected Requirement(String name, String displayName, String cardNumber, String type, String narrativeText) {
        this.name = name;
        this.displayName = displayName;
        this.cardNumber = cardNumber;
        this.type = type;
        this.narrativeText = narrativeText;
        this.children = Collections.EMPTY_LIST;
        this.examples = Collections.EMPTY_LIST;
        this.releaseVersions = Collections.EMPTY_LIST;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getType() {
        return this.type;
    }

    public String childType() {
        return !this.children.isEmpty() ? this.children.get(0).getType() : null;
    }

    public String getNarrativeText() {
        return this.narrativeText;
    }

    public List<String> getReleaseVersions() {
        return this.releaseVersions;
    }

    @JsonIgnore
    public int getChildrenCount() {
        return this.children.size();
    }

    public List<Requirement> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public List<Example> getExamples() {
        return ImmutableList.copyOf(this.examples);
    }

    public Boolean hasExamples() {
        return !this.examples.isEmpty();
    }

    @JsonIgnore
    public int getExampleCount() {
        return this.examples.size();
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public int compareTo(Object otherRequirement) {
        return this.name.compareTo(((Requirement)otherRequirement).getName());
    }

    public static RequirementBuilderNameStep named(String name) {
        return new RequirementBuilderNameStep(name);
    }

    public Requirement withChildren(List<Requirement> children) {
        return new Requirement(this.name, this.displayName, this.cardNumber, this.type, this.narrativeText, children, this.examples, this.releaseVersions);
    }

    public Requirement withExample(Example example) {
        ArrayList updatedExamples = Lists.newArrayList(this.examples);
        updatedExamples.add(example);
        return new Requirement(this.name, this.displayName, this.cardNumber, this.type, this.narrativeText, this.children, updatedExamples, this.releaseVersions);
    }

    public Requirement withExamples(List<Example> examples) {
        return new Requirement(this.name, this.displayName, this.cardNumber, this.type, this.narrativeText, this.children, examples, this.releaseVersions);
    }

    public Requirement withReleaseVersions(List<String> releaseVersions) {
        return new Requirement(this.name, this.displayName, this.cardNumber, this.type, this.narrativeText, this.children, this.examples, releaseVersions);
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<Requirement> getNestedChildren() {
        ArrayList nestedChildren = Lists.newArrayList();
        for (Requirement child : this.children) {
            nestedChildren.add(child);
            nestedChildren.addAll(child.getNestedChildren());
        }
        return ImmutableList.copyOf((Collection)nestedChildren);
    }

    public TestTag asTag() {
        return TestTag.withName(this.getName()).andType(this.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Requirement that = (Requirement)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Requirement{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", cardNumber='" + this.cardNumber + '\'' + '}';
    }

    public Requirement withChild(Requirement child) {
        ArrayList newChildren = Lists.newArrayList(this.children);
        newChildren.remove(child);
        newChildren.add(child);
        return new Requirement(this.name, this.displayName, this.cardNumber, this.type, this.narrativeText, newChildren, this.examples, this.releaseVersions);
    }
}

