/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportGenerationFailedError;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.webdriver.Configuration;
import sun.misc.Service;

public class ReportService {
    private File outputDirectory;
    private List<AcceptanceTestReporter> subscribedReporters;

    @Inject
    public ReportService(Configuration configuration) {
        this(configuration.getOutputDirectory(), ReportService.getDefaultReporters());
    }

    public ReportService(File outputDirectory, Collection<AcceptanceTestReporter> subscribedReporters) {
        this.outputDirectory = outputDirectory;
        this.getSubscribedReporters().addAll(subscribedReporters);
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List<AcceptanceTestReporter> getSubscribedReporters() {
        if (this.subscribedReporters == null) {
            this.subscribedReporters = new ArrayList<AcceptanceTestReporter>();
        }
        return this.subscribedReporters;
    }

    public void subscribe(AcceptanceTestReporter reporter) {
        this.getSubscribedReporters().add(reporter);
    }

    public void useQualifier(String qualifier) {
        for (AcceptanceTestReporter reporter : this.getSubscribedReporters()) {
            reporter.setQualifier(qualifier);
        }
    }

    public void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        TestOutcomes allTestOutcomes = TestOutcomes.of(testOutcomeResults);
        for (AcceptanceTestReporter reporter : this.getSubscribedReporters()) {
            for (TestOutcome testOutcomeResult : testOutcomeResults) {
                this.generateReportFor(testOutcomeResult, allTestOutcomes, reporter);
            }
        }
    }

    public static List<AcceptanceTestReporter> getDefaultReporters() {
        ArrayList<AcceptanceTestReporter> reporters = new ArrayList<AcceptanceTestReporter>();
        Iterator reporterImplementations = Service.providers(AcceptanceTestReporter.class);
        while (reporterImplementations.hasNext()) {
            reporters.add((AcceptanceTestReporter)reporterImplementations.next());
        }
        return reporters;
    }

    private void generateReportFor(TestOutcome testOutcome, TestOutcomes allTestOutcomes, AcceptanceTestReporter reporter) {
        try {
            reporter.setOutputDirectory(this.outputDirectory);
            reporter.generateReportFor(testOutcome, allTestOutcomes);
        }
        catch (IOException e) {
            throw new ReportGenerationFailedError("Failed to generate reports using " + reporter, e);
        }
    }
}

