/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.specflow;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import org.apache.commons.lang3.StringUtils;

public class SpecflowScenarioTitleLine {
    public static final String START_ARGUMENT = "(";
    public static final char ESCAPE_CHAR = '\\';
    public static final char STRING_SEP = '\"';
    public static final char ARG_SEP = ',';
    public static final char END_ARGUMENT = ')';
    public static final String NULL = "null";
    private final String scenarioTitle;
    private final String storyTitle;
    private final String storyPath;
    private final List<String> parameters;
    private final Inflector inflector = new Inflector();
    private final EnvironmentVariables environmentVariables;

    public SpecflowScenarioTitleLine(String titleLine, EnvironmentVariables environmentVariables) {
        List<String> titleElements = this.elementsFrom(this.stripLead(titleLine));
        this.environmentVariables = environmentVariables;
        this.scenarioTitle = this.scenarioTitleIn((String)Lists.reverse(titleElements).get(0));
        this.storyTitle = this.storyTitleIn(titleElements);
        this.storyPath = this.pathFrom(titleElements);
        this.parameters = this.argumentsFrom(titleLine);
    }

    private List<String> argumentsFrom(String titleLine) {
        if (!titleLine.contains(START_ARGUMENT)) {
            return Lists.newArrayList();
        }
        String argumentString = titleLine.substring(titleLine.indexOf(START_ARGUMENT) + 1, titleLine.lastIndexOf(41));
        ArrayList result = Lists.newArrayList();
        StringBuilder currentResult = new StringBuilder();
        boolean inString = false;
        int i = 0;
        while (i < argumentString.length()) {
            Character c = Character.valueOf(argumentString.charAt(i));
            if (c.charValue() == '\\') {
                currentResult.append(argumentString.charAt(++i));
            } else if (c.charValue() == '\"') {
                inString = !inString;
            } else if (c.charValue() == ',' && !inString) {
                this.addResult(result, currentResult);
                currentResult = new StringBuilder();
            } else {
                currentResult.append(c);
            }
            ++i;
        }
        if (currentResult.length() != 0) {
            this.addResult(result, currentResult);
        }
        return result;
    }

    private void addResult(List<String> result, StringBuilder currentResult) {
        String s = currentResult.toString();
        if (s.equals(NULL)) {
            s = "";
        }
        result.add(s);
    }

    public SpecflowScenarioTitleLine(String titleLine) {
        this(titleLine, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    private String pathFrom(List<String> titleElements) {
        List<Object> pathElements = Lists.newArrayList(titleElements);
        pathElements.remove(pathElements.size() - 1);
        pathElements = this.removeExcludedElementsFrom(pathElements);
        return Joiner.on((String)".").join((Iterable)pathElements);
    }

    private List<String> removeExcludedElementsFrom(List<String> pathElements) {
        ArrayList purgedPathElements = Lists.newArrayList(pathElements);
        String excludedElementConfiguration = this.environmentVariables.getProperty(ThucydidesSystemProperty.REQUIREMENT_EXCLUSIONS, "");
        ArrayList excludedElements = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)excludedElementConfiguration));
        purgedPathElements.removeAll(excludedElements);
        return purgedPathElements;
    }

    private String storyTitleIn(List<String> titleElements) {
        List reverseTitleElements = Lists.reverse(titleElements);
        return this.inflector.of((String)reverseTitleElements.get(1)).inHumanReadableForm().toString();
    }

    private String scenarioTitleIn(String titleElement) {
        return (String)Splitter.on((String)START_ARGUMENT).split((CharSequence)titleElement).iterator().next();
    }

    private List<String> elementsFrom(String titleElements) {
        return Lists.newCopyOnWriteArrayList((Iterable)Splitter.on((String)".").split((CharSequence)titleElements));
    }

    private String stripLead(String titleLine) {
        return StringUtils.strip((String)titleLine, (String)"* ");
    }

    public String getScenarioTitle() {
        return this.scenarioTitle;
    }

    public String getStoryTitle() {
        return this.storyTitle;
    }

    public String getStoryPath() {
        return this.storyPath;
    }

    public String getTitleName() {
        return String.valueOf(this.storyPath) + "." + this.scenarioTitle;
    }

    public List getArguments() {
        return this.parameters;
    }

    public String getRowTitle() {
        return String.valueOf(this.scenarioTitle) + "[" + this.getArguments() + "]";
    }
}

