/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Optional;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.thucydides.core.model.TestFailureException;

public class FailureCause {
    public static final String ERROR_MESSAGE_LABEL_1 = "{'errorMessage':";
    public static final String ERROR_MESSAGE_LABEL_2 = "{\"errorMessage\":";
    private String errorType;
    private String message;
    private StackTraceElement[] stackTrace;

    public FailureCause() {
    }

    public FailureCause(Throwable cause) {
        this.errorType = cause.getClass().getName();
        this.message = cause.getMessage();
        this.stackTrace = cause.getStackTrace();
    }

    public FailureCause(Throwable cause, StackTraceElement[] stackTrace) {
        this(cause.getClass().getName(), cause.getMessage(), stackTrace);
    }

    public FailureCause(String errorType, String message, StackTraceElement[] stackTrace) {
        this.errorType = errorType;
        this.message = this.parseErrorMessage(message);
        this.stackTrace = stackTrace;
    }

    private String parseErrorMessage(String message) {
        if (message != null && (message.startsWith(ERROR_MESSAGE_LABEL_1) || message.startsWith(ERROR_MESSAGE_LABEL_2))) {
            return this.extractErrorMessageTextFrom(message);
        }
        return message;
    }

    private String extractErrorMessageTextFrom(String message) {
        int endOfMessage = (message = message.substring(ERROR_MESSAGE_LABEL_1.length() + 1)).indexOf("','");
        if (endOfMessage == -1) {
            endOfMessage = message.indexOf("\",\"");
        }
        if (endOfMessage > 0) {
            return message.substring(0, endOfMessage);
        }
        return message;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return this.message;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public Class<? extends Throwable> exceptionClass() {
        try {
            return Class.forName(this.errorType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Throwable.class;
        }
    }

    public String toString() {
        return "FailureCause{errorType='" + this.errorType + '\'' + ", message='" + this.message + '\'' + ", stackTrace=" + Arrays.toString(this.stackTrace) + '}';
    }

    public Throwable toException() {
        Optional<Throwable> exception = this.restoreExceptionFrom(this.errorType, this.message);
        if (exception.isPresent()) {
            return (Throwable)exception.get();
        }
        return new TestFailureException(String.valueOf(this.errorType) + ":" + this.message);
    }

    private Optional<Throwable> restoreExceptionFrom(String testFailureClassname, String testFailureMessage) {
        try {
            Class<?> failureClass = Class.forName(testFailureClassname);
            Constructor constructorWithMessage = this.getExceptionConstructor(failureClass);
            Throwable exception = (Throwable)constructorWithMessage.newInstance(testFailureMessage);
            exception.setStackTrace(this.getStackTrace());
            return Optional.of((Object)exception);
        }
        catch (Exception exception) {
            return Optional.absent();
        }
    }

    private Constructor getExceptionConstructor(Class failureClass) throws NoSuchMethodException {
        try {
            return failureClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return failureClass.getConstructor(Object.class);
        }
    }
}

