/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.images;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SimpleImageInfo {
    private int height;
    private int width;

    public SimpleImageInfo(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            this.processStream(is);
        }
    }

    private void processStream(InputStream is) throws IOException {
        int c1 = is.read();
        int c2 = is.read();
        int c3 = is.read();
        this.height = -1;
        this.width = -1;
        if (c1 != 137 || c2 != 80 || c3 != 78) {
            throw new IOException("Unsupported image type");
        }
        is.skip(15L);
        this.width = this.readInt(is, 2);
        is.skip(2L);
        this.height = this.readInt(is, 2);
    }

    private int readInt(InputStream is, int noOfBytes) throws IOException {
        int ret = 0;
        int sv = (noOfBytes - 1) * 8;
        int cnt = -8;
        int i = 0;
        while (i < noOfBytes) {
            ret |= is.read() << sv;
            sv += cnt;
            ++i;
        }
        return ret;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

