/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.thucydides.core.model.DataTableRow;

public class DataSet {
    private final int startRow;
    private final String name;
    private final String description;
    private final List<DataTableRow> rows;

    public DataSet(int startRow, int rowCount, String name, String description, List<DataTableRow> rows) {
        this.startRow = startRow;
        this.name = name;
        this.description = description;
        this.rows = this.extractRows(rows, startRow, rowCount);
    }

    private List<DataTableRow> extractRows(List<DataTableRow> rows, int startRow, int rowCount) {
        int endRow = rowCount == 0 ? rows.size() : startRow + rowCount;
        return ImmutableList.copyOf(rows.subList(startRow, endRow));
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public List<DataTableRow> getRows() {
        return this.rows;
    }
}

