/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers.dates;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.thucydides.core.matchers.dates.DateComparator;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateCollectionContainsSameDatesMatcher
extends TypeSafeMatcher<Collection<Date>> {
    private final Collection<Date> expectedDates;

    public DateCollectionContainsSameDatesMatcher(Collection<Date> expectedDates) {
        this.expectedDates = expectedDates;
    }

    public boolean matchesSafely(Collection<Date> dates) {
        if (dates.size() != this.expectedDates.size()) {
            return false;
        }
        for (Date expectedDate : this.expectedDates) {
            if (this.hasIdenticalDate(expectedDate, dates)) continue;
            return false;
        }
        return true;
    }

    private boolean hasIdenticalDate(Date expectedDate, Collection<Date> dates) {
        for (Date date : dates) {
            if (!DateComparator.sameDate(date, expectedDate)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a collection of dates containing ");
        List dates = Lambda.convert(this.expectedDates, this.toReadableForm());
        description.appendText("[" + Lambda.join((Object)dates) + "]");
    }

    private Converter<Date, String> toReadableForm() {
        return new Converter<Date, String>(){

            public String convert(Date from) {
                return new DateTime((Object)from).toString("d MMM yyyy HH:mm:ss");
            }
        };
    }
}

