/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.PageObject;
import net.thucydides.core.pages.WrongPageError;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pages
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient WebDriver driver;
    private static final Logger LOGGER = LoggerFactory.getLogger(Pages.class);
    private String defaultBaseUrl;
    private final Configuration configuration;
    private WebdriverProxyFactory proxyFactory;
    private transient boolean usePreviousPage = false;
    PageObject currentPage = null;

    public Pages(Configuration configuration) {
        this.configuration = configuration;
        this.proxyFactory = WebdriverProxyFactory.getFactory();
    }

    public Pages() {
        this((Configuration)Injectors.getInjector().getInstance(Configuration.class));
    }

    public Pages(WebDriver driver) {
        this((Configuration)Injectors.getInjector().getInstance(Configuration.class));
        this.driver = driver;
    }

    public Pages(WebDriver driver, Configuration Configuration2) {
        this(Configuration2);
        this.driver = driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    protected WebdriverProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public <T extends PageObject> T getAt(Class<T> pageObjectClass) {
        return this.getPage(pageObjectClass);
    }

    public <T extends PageObject> T getPage(Class<T> pageObjectClass) {
        T pageCandidate = this.getCurrentPageOfType(pageObjectClass);
        ((PageObject)pageCandidate).setDefaultBaseUrl(this.getDefaultBaseUrl());
        return pageCandidate;
    }

    public <T extends PageObject> T get(Class<T> pageObjectClass) {
        PageObject nextPage;
        if (this.shouldUsePreviousPage(pageObjectClass)) {
            nextPage = this.currentPage;
        } else {
            T pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            ((PageObject)pageCandidate).setDefaultBaseUrl(this.getDefaultBaseUrl());
            this.cacheCurrentPage((PageObject)pageCandidate);
            nextPage = pageCandidate;
        }
        this.usePreviousPage = false;
        return (T)nextPage;
    }

    public <T extends PageObject> T currentPageAt(Class<T> pageObjectClass) {
        PageObject nextPage;
        if (this.shouldUsePreviousPage(pageObjectClass)) {
            nextPage = this.currentPage;
        } else {
            T pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            ((PageObject)pageCandidate).setDefaultBaseUrl(this.getDefaultBaseUrl());
            this.openBrowserIfRequiredFor(pageCandidate);
            this.checkUrlPatterns(pageObjectClass, pageCandidate);
            this.cacheCurrentPage((PageObject)pageCandidate);
            nextPage = pageCandidate;
            nextPage.addJQuerySupport();
        }
        this.usePreviousPage = false;
        return (T)nextPage;
    }

    private <T extends PageObject> void openBrowserIfRequiredFor(T pageCandidate) {
        if (this.browserNotOpen()) {
            this.openHeadlessDriverIfNotOpen();
            pageCandidate.open();
        }
    }

    private void openHeadlessDriverIfNotOpen() {
        if (this.browserIsHeadless()) {
            this.driver.get("about:blank");
        }
    }

    private boolean browserNotOpen() {
        if (this.getDriver() instanceof WebDriverFacade) {
            return !((WebDriverFacade)this.getDriver()).isInstantiated();
        }
        return StringUtils.isEmpty((CharSequence)this.getDriver().getCurrentUrl());
    }

    private boolean browserIsHeadless() {
        if (this.getDriver() instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.getDriver()).getProxiedDriver() instanceof HtmlUnitDriver;
        }
        return this.getDriver() instanceof HtmlUnitDriver;
    }

    private <T extends PageObject> void checkUrlPatterns(Class<T> pageObjectClass, T pageCandidate) {
        String currentUrl;
        if (!pageCandidate.matchesAnyUrl() && !pageCandidate.compatibleWithUrl(currentUrl = this.getDriver().getCurrentUrl())) {
            this.thisIsNotThePageYourLookingFor(pageObjectClass);
        }
    }

    private <T extends PageObject> boolean shouldUsePreviousPage(Class<T> pageObjectClass) {
        if (!this.usePreviousPage) {
            return false;
        }
        return this.currentPageIsSameTypeAs(pageObjectClass);
    }

    private void cacheCurrentPage(PageObject newPage) {
        this.currentPage = newPage;
    }

    private <T extends PageObject> boolean currentPageIsSameTypeAs(Class<T> pageObjectClass) {
        return this.currentPage != null && this.currentPage.getClass().equals(pageObjectClass);
    }

    public boolean isCurrentPageAt(Class<? extends PageObject> pageObjectClass) {
        try {
            PageObject pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            String currentUrl = this.getDriver().getCurrentUrl();
            return pageCandidate.compatibleWithUrl(currentUrl);
        }
        catch (WrongPageError e) {
            return false;
        }
    }

    private <T extends PageObject> T getCurrentPageOfType(Class<T> pageObjectClass) {
        PageObject currentPage = null;
        try {
            Class[] constructorArgs = new Class[]{WebDriver.class};
            Constructor<T> constructor = pageObjectClass.getConstructor(constructorArgs);
            currentPage = (PageObject)constructor.newInstance(this.driver);
        }
        catch (NoSuchMethodException e) {
            LOGGER.info("This page object does not appear have a constructor that takes a WebDriver parameter: {} ({})", pageObjectClass, (Object)e.getMessage());
            this.thisPageObjectLooksDodgy(pageObjectClass, "This page object does not appear have a constructor that takes a WebDriver parameter");
        }
        catch (Exception e) {
            LOGGER.info("Failed to instantiate page of type {} ({})", pageObjectClass, (Object)e.getMessage());
            this.thisPageObjectLooksDodgy(pageObjectClass, "Failed to instantiate page (" + e.getMessage() + ")");
        }
        return (T)currentPage;
    }

    private void thisPageObjectLooksDodgy(Class<? extends PageObject> pageObjectClass, String message) {
        String errorDetails = "The page object " + pageObjectClass + " looks dodgy:\n" + message;
        throw new WrongPageError(errorDetails);
    }

    private void thisIsNotThePageYourLookingFor(Class<? extends PageObject> pageObjectClass) {
        String errorDetails = "This is not the page you're looking for:\nI was looking for a page compatible with " + pageObjectClass + "\n" + "I was at the URL " + this.getDriver().getCurrentUrl();
        throw new WrongPageError(errorDetails);
    }

    public String getDefaultBaseUrl() {
        String baseUrl = this.defaultBaseUrl;
        if (StringUtils.isNotEmpty((CharSequence)this.getConfiguration().getBaseUrl())) {
            baseUrl = this.getConfiguration().getBaseUrl();
        }
        return baseUrl;
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }

    public Pages onSamePage() {
        this.usePreviousPage = true;
        return this;
    }
}

