/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Transient;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.RequirementsPath;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Narrative;
import net.thucydides.core.requirements.model.NarrativeReader;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemRequirementsTagProvider
implements RequirementsTagProvider {
    public static final List<String> DEFAULT_CAPABILITY_TYPES = ImmutableList.of((Object)"capability", (Object)"feature");
    private static final String DEFAULT_ROOT_DIRECTORY = "stories";
    private static final String DEFAULT_RESOURCE_DIRECTORY = "src/test/resources";
    private static final String WORKING_DIR = "user.dir";
    private static final List<Requirement> NO_REQUIREMENTS = Lists.newArrayList();
    private static final List<TestTag> NO_TEST_TAGS = Lists.newArrayList();
    private final String rootDirectoryPath;
    private final NarrativeReader narrativeReader;
    private final int level;
    private final EnvironmentVariables environmentVariables;
    @Transient
    private List<Requirement> requirements;

    public FileSystemRequirementsTagProvider() {
        this(FileSystemRequirementsTagProvider.getDefaultRootDirectoryPathFrom((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class)));
    }

    public static String getDefaultRootDirectoryPathFrom(EnvironmentVariables environmentVariables) {
        String rootPath = ThucydidesSystemProperty.THUCYDIDES_TEST_ROOT.from(environmentVariables);
        if (StringUtils.isEmpty((CharSequence)rootPath)) {
            return DEFAULT_ROOT_DIRECTORY;
        }
        return rootPath;
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, int level) {
        this(FileSystemRequirementsTagProvider.filePathFormOf(rootDirectory), level, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    private static String filePathFormOf(String rootDirectory) {
        if (rootDirectory.contains(".")) {
            return rootDirectory.replace(".", "/");
        }
        return rootDirectory;
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, int level, EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.rootDirectoryPath = rootDirectory;
        this.level = level;
        this.narrativeReader = NarrativeReader.forRootDirectory(rootDirectory).withRequirementTypes(this.getRequirementTypes());
    }

    public FileSystemRequirementsTagProvider(String rootDirectory) {
        this(rootDirectory, 0);
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            Object rootDirectoryPath = null;
            try {
                Optional<String> directoryPath = this.getRootDirectoryPath();
                if (directoryPath.isPresent()) {
                    File rootDirectory = new File((String)directoryPath.get());
                    ArrayList allRequirements = Lists.newArrayList();
                    allRequirements.addAll(this.loadCapabilitiesFrom(rootDirectory.listFiles(this.thatAreDirectories())));
                    allRequirements.addAll(this.loadStoriesFrom(rootDirectory.listFiles(this.thatAreStories())));
                    Collections.sort(allRequirements);
                    this.requirements = allRequirements;
                } else {
                    this.requirements = NO_REQUIREMENTS;
                }
            }
            catch (IOException e) {
                this.requirements = NO_REQUIREMENTS;
                throw new IllegalArgumentException("Could not load requirements from '" + rootDirectoryPath + "'", e);
            }
        }
        return this.requirements;
    }

    private Optional<String> getRootDirectoryPath() throws IOException {
        if (ThucydidesSystemProperty.TEST_REQUIREMENTS_ROOT.isDefinedIn(this.environmentVariables)) {
            return this.getRootDirectoryFromRequirementsBaseDir();
        }
        Optional<String> rootDirectoryOnClasspath = this.getRootDirectoryFromClasspath();
        if (rootDirectoryOnClasspath.isPresent()) {
            return rootDirectoryOnClasspath;
        }
        return this.getRootDirectoryFromWorkingDirectory();
    }

    private Optional<String> getRootDirectoryFromClasspath() throws IOException {
        Enumeration<URL> requirementResources = this.getDirectoriesFrom(this.rootDirectoryPath);
        if (requirementResources.hasMoreElements()) {
            return Optional.of((Object)requirementResources.nextElement().getPath());
        }
        return Optional.absent();
    }

    private Optional<String> getRootDirectoryFromWorkingDirectory() throws IOException {
        return this.getRootDirectoryFromParentDir(System.getProperty(WORKING_DIR));
    }

    private Optional<String> getRootDirectoryFromRequirementsBaseDir() {
        return this.getRootDirectoryFromParentDir(ThucydidesSystemProperty.TEST_REQUIREMENTS_ROOT.from(this.environmentVariables, ""));
    }

    private Optional<String> getRootDirectoryFromParentDir(String parentDir) {
        File workingDirectory = new File(parentDir);
        File resourceDirectory = new File(workingDirectory, DEFAULT_RESOURCE_DIRECTORY);
        File requirementsDirectory = new File(resourceDirectory, this.rootDirectoryPath);
        if (requirementsDirectory.exists()) {
            return Optional.of((Object)requirementsDirectory.getAbsolutePath());
        }
        return Optional.absent();
    }

    private Enumeration<URL> getDirectoriesFrom(String root) throws IOException {
        return this.getClass().getClassLoader().getResources(root);
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet<TestTag> tags = new HashSet<TestTag>();
        if (testOutcome.getPath() != null) {
            List<String> storyPathElements = this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath())));
            this.addStoryTagIfPresent(tags, storyPathElements);
            storyPathElements = this.stripStorySuffixFrom(storyPathElements);
            tags.addAll(this.getMatchingCapabilities(this.getRequirements(), storyPathElements));
        }
        return tags;
    }

    private List<String> stripStorySuffixFrom(List<String> pathElements) {
        if (!pathElements.isEmpty() && this.last(pathElements).toLowerCase().equals("story")) {
            return this.dropLastElement(pathElements);
        }
        return pathElements;
    }

    private List<String> dropLastElement(List<String> pathElements) {
        ArrayList strippedPathElements = Lists.newArrayList(pathElements);
        strippedPathElements.remove(pathElements.size() - 1);
        return strippedPathElements;
    }

    private void addStoryTagIfPresent(Set<TestTag> tags, List<String> storyPathElements) {
        Optional<TestTag> storyTag = this.storyTagFrom(storyPathElements);
        tags.addAll(storyTag.asSet());
    }

    private Optional<TestTag> storyTagFrom(List<String> storyPathElements) {
        if (!storyPathElements.isEmpty() && this.last(storyPathElements).equals("story")) {
            String storyName = (String)Lists.reverse(storyPathElements).get(1);
            TestTag storyTag = TestTag.withName(NameConverter.humanize(storyName)).andType("story");
            return Optional.of((Object)storyTag);
        }
        return Optional.absent();
    }

    private String last(List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        if (testOutcome.getPath() != null) {
            List<String> storyPathElements = this.stripStorySuffixFrom(this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath()))));
            return this.lastRequirementFrom(storyPathElements);
        }
        return Optional.absent();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        for (Requirement requirement : this.getRequirements()) {
            if (!requirement.getName().equals(testTag.getName()) || !requirement.getType().equals(testTag.getType())) continue;
            return Optional.of((Object)requirement);
        }
        return Optional.absent();
    }

    private Optional<Requirement> lastRequirementFrom(List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return Optional.absent();
        }
        return this.lastRequirementMatchingPath(this.getRequirements(), storyPathElements);
    }

    private Optional<Requirement> lastRequirementMatchingPath(List<Requirement> requirements, List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return Optional.absent();
        }
        Optional<Requirement> matchingRequirement = this.findMatchingRequirementIn(this.next(storyPathElements), requirements);
        if (!matchingRequirement.isPresent()) {
            return Optional.absent();
        }
        if (this.tail(storyPathElements).isEmpty()) {
            return matchingRequirement;
        }
        List<Requirement> childRequrements = ((Requirement)matchingRequirement.get()).getChildren();
        return this.lastRequirementMatchingPath(childRequrements, this.tail(storyPathElements));
    }

    private List<TestTag> getMatchingCapabilities(List<Requirement> requirements, List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return NO_TEST_TAGS;
        }
        Optional<Requirement> matchingRequirement = this.findMatchingRequirementIn(this.next(storyPathElements), requirements);
        if (matchingRequirement.isPresent()) {
            TestTag thisTag = TestTag.withName(((Requirement)matchingRequirement.get()).getName()).andType(((Requirement)matchingRequirement.get()).getType());
            List<TestTag> remainingTags = this.getMatchingCapabilities(((Requirement)matchingRequirement.get()).getChildren(), this.tail(storyPathElements));
            return this.concat(thisTag, remainingTags);
        }
        return NO_TEST_TAGS;
    }

    private List<String> stripRootFrom(List<String> storyPathElements) {
        return RequirementsPath.stripRootFromPath(this.rootDirectoryPath, storyPathElements);
    }

    private String stripRootPathFrom(String testOutcomePath) {
        String rootPath = ThucydidesSystemProperty.THUCYDIDES_TEST_ROOT.from(this.environmentVariables);
        if (rootPath != null && testOutcomePath.startsWith(rootPath)) {
            return testOutcomePath.substring(rootPath.length() + 1);
        }
        return testOutcomePath;
    }

    private List<TestTag> concat(TestTag thisTag, List<TestTag> remainingTags) {
        ArrayList<TestTag> totalTags = new ArrayList<TestTag>();
        totalTags.add(thisTag);
        totalTags.addAll(remainingTags);
        return totalTags;
    }

    private <T> T next(List<T> elements) {
        return elements.get(0);
    }

    private <T> List<T> tail(List<T> elements) {
        return elements.subList(1, elements.size());
    }

    private Optional<Requirement> findMatchingRequirementIn(String storyPathElement, List<Requirement> requirements) {
        for (Requirement requirement : requirements) {
            String normalizedStoryPathElement = Inflector.getInstance().humanize(Inflector.getInstance().underscore(storyPathElement, new char[0]), new String[0]);
            if (!requirement.getName().equals(normalizedStoryPathElement)) continue;
            return Optional.of((Object)requirement);
        }
        return Optional.absent();
    }

    private List<Requirement> loadCapabilitiesFrom(File[] requirementDirectories) {
        return Lambda.convert((Object)requirementDirectories, this.toRequirements());
    }

    private List<Requirement> loadStoriesFrom(File[] storyFiles) {
        return Lambda.convert((Object)storyFiles, this.toStoryRequirements());
    }

    private Converter<File, Requirement> toRequirements() {
        return new Converter<File, Requirement>(){

            public Requirement convert(File requirementFileOrDirectory) {
                return FileSystemRequirementsTagProvider.this.readRequirementFrom(requirementFileOrDirectory);
            }
        };
    }

    private Converter<File, Requirement> toStoryRequirements() {
        return new Converter<File, Requirement>(){

            public Requirement convert(File storyFile) {
                return FileSystemRequirementsTagProvider.this.readRequirementsFromStoryFile(storyFile);
            }
        };
    }

    private Requirement readRequirementFrom(File requirementDirectory) {
        Optional<Narrative> requirementNarrative = this.narrativeReader.loadFrom(requirementDirectory, this.level);
        if (requirementNarrative.isPresent()) {
            return this.requirementWithNarrative(requirementDirectory, this.humanReadableVersionOf(requirementDirectory.getName()), (Narrative)requirementNarrative.get());
        }
        return this.requirementFromDirectoryName(requirementDirectory);
    }

    private Requirement readRequirementsFromStoryFile(File storyFile) {
        Optional<Narrative> optionalNarrative = this.narrativeReader.loadFromStoryFile(storyFile);
        String storyName = storyFile.getName().replace(".story", "");
        if (optionalNarrative.isPresent()) {
            return this.requirementWithNarrative(storyFile, this.humanReadableVersionOf(storyName), (Narrative)optionalNarrative.get());
        }
        return this.storyNamed(storyName);
    }

    private Requirement requirementFromDirectoryName(File requirementDirectory) {
        String shortName = this.humanReadableVersionOf(requirementDirectory.getName());
        List<Requirement> children = this.readChildrenFrom(requirementDirectory);
        return Requirement.named(shortName).withType(this.getDefaultType()).withNarrativeText(shortName).withChildren(children);
    }

    private Requirement storyNamed(String storyName) {
        String shortName = this.humanReadableVersionOf(storyName);
        return Requirement.named(shortName).withType("story").withNarrativeText(shortName);
    }

    private Requirement requirementWithNarrative(File requirementDirectory, String shortName, Narrative requirementNarrative) {
        String displayName = this.getTitleFromNarrativeOrDirectoryName(requirementNarrative, shortName);
        String cardNumber = (String)requirementNarrative.getCardNumber().orNull();
        String type = requirementNarrative.getType();
        List<Requirement> children = this.readChildrenFrom(requirementDirectory);
        return Requirement.named(shortName).withOptionalDisplayName(displayName).withOptionalCardNumber(cardNumber).withType(type).withNarrativeText(requirementNarrative.getText()).withChildren(children);
    }

    private String getDefaultType() {
        List<String> types = this.getRequirementTypes();
        if (this.level > types.size() - 1) {
            return types.get(types.size() - 1);
        }
        return types.get(this.level);
    }

    private List<String> getRequirementTypes() {
        String requirementTypes = ThucydidesSystemProperty.CAPABILITY_TYPES.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)requirementTypes)) {
            Iterator types = Splitter.on((String)",").trimResults().split((CharSequence)requirementTypes).iterator();
            return Lists.newArrayList(types);
        }
        return DEFAULT_CAPABILITY_TYPES;
    }

    private List<Requirement> readChildrenFrom(File requirementDirectory) {
        String childDirectory = this.rootDirectoryPath + "/" + requirementDirectory.getName();
        FileSystemRequirementsTagProvider childReader = new FileSystemRequirementsTagProvider(childDirectory, this.level + 1, this.environmentVariables);
        return childReader.getRequirements();
    }

    private String getTitleFromNarrativeOrDirectoryName(Narrative requirementNarrative, String nameIfNoNarrativePresent) {
        if (requirementNarrative.getTitle().isPresent()) {
            return (String)requirementNarrative.getTitle().get();
        }
        return nameIfNoNarrativePresent;
    }

    private String humanReadableVersionOf(String name) {
        String underscoredName = Inflector.getInstance().underscore(name, new char[0]);
        return Inflector.getInstance().humanize(underscoredName, new String[0]);
    }

    private FileFilter thatAreDirectories() {
        return new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && !file.getName().startsWith(".");
            }
        };
    }

    private FileFilter thatAreStories() {
        return new FileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".story");
            }
        };
    }
}

