/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.util.List;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.requirements.model.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementOutcome {
    private final Requirement requirement;
    private final TestOutcomes testOutcomes;
    private IssueTracking issueTracking;

    public RequirementOutcome(Requirement requirement, TestOutcomes testOutcomes, IssueTracking issueTracking) {
        this.requirement = requirement;
        this.testOutcomes = testOutcomes;
        this.issueTracking = issueTracking;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public boolean isComplete() {
        return this.getTestOutcomes().getResult() == TestResult.SUCCESS && this.allChildRequirementsAreSuccessful();
    }

    public boolean isFailure() {
        return this.getTestOutcomes().getResult() == TestResult.FAILURE || this.anyChildRequirementsAreFailures();
    }

    private boolean allChildRequirementsAreSuccessful() {
        if (this.requirement.hasChildren()) {
            return this.allChildRequirementsAreSuccessfulFor(this.requirement.getChildren());
        }
        return true;
    }

    private boolean anyChildRequirementsAreFailures() {
        return this.anyChildRequirementsAreFailuresFor(this.requirement.getChildren());
    }

    private boolean allChildRequirementsAreSuccessfulFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (!childOutcomes.isComplete()) {
                return false;
            }
            if (this.allChildRequirementsAreSuccessfulFor(childRequirement.getChildren())) continue;
            return false;
        }
        return true;
    }

    private boolean anyChildRequirementsAreFailuresFor(List<Requirement> requirements) {
        for (Requirement childRequirement : requirements) {
            RequirementOutcome childOutcomes = new RequirementOutcome(childRequirement, this.testOutcomes.forRequirement(this.requirement), this.issueTracking);
            if (childOutcomes.isFailure()) {
                return true;
            }
            if (!this.anyChildRequirementsAreFailuresFor(childRequirement.getChildren())) continue;
            return true;
        }
        return false;
    }

    public String getCardNumberWithLinks() {
        if (this.requirement.getCardNumber() != null) {
            return this.getFormatter().addLinks(this.requirement.getCardNumber());
        }
        return "";
    }

    private Formatter getFormatter() {
        return new Formatter(this.issueTracking);
    }

    public String toString() {
        return "RequirementOutcome{requirement=" + this.requirement + ", testOutcomes=" + this.testOutcomes + '}';
    }
}

