/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import ch.lambdaj.Lambda;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirmentsOutcomeFactory {
    private final List<RequirementsTagProvider> requirementsTagProviders;
    private final IssueTracking issueTracking;

    public RequirmentsOutcomeFactory(List<RequirementsTagProvider> requirementsTagProviders, IssueTracking issueTracking) {
        this.requirementsTagProviders = ImmutableList.copyOf(requirementsTagProviders);
        this.issueTracking = issueTracking;
    }

    public RequirementsOutcomes buildRequirementsOutcomesFrom(TestOutcomes testOutcomes) {
        List allRequirements = Lambda.flatten((Object)Lambda.extract(this.requirementsTagProviders, ((RequirementsTagProvider)Lambda.on(RequirementsTagProvider.class)).getRequirements()));
        return new RequirementsOutcomes(allRequirements, testOutcomes, this.issueTracking);
    }

    public RequirementsOutcomes buildRequirementsOutcomesFrom(Requirement parentRequirement, TestOutcomes testOutcomes) {
        List<Requirement> childRequirements = parentRequirement.getChildren();
        return new RequirementsOutcomes(parentRequirement, childRequirements, testOutcomes, this.issueTracking);
    }
}

