/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.scheduling;

import java.util.concurrent.TimeUnit;
import net.thucydides.core.scheduling.ThucydidesFluentWait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimeSchedule<T> {
    protected final ThucydidesFluentWait<T> fluentWait;
    private final int amount;

    public TimeSchedule(ThucydidesFluentWait<T> fluentWait, int amount) {
        this.fluentWait = fluentWait;
        this.amount = amount;
    }

    protected abstract ThucydidesFluentWait<T> updateWaitBy(int var1, TimeUnit var2);

    public ThucydidesFluentWait<T> milliseconds() {
        return this.updateWaitBy(this.amount, TimeUnit.MILLISECONDS);
    }

    public ThucydidesFluentWait<T> second() {
        return this.updateWaitBy(this.amount, TimeUnit.SECONDS);
    }

    public ThucydidesFluentWait<T> seconds() {
        return this.updateWaitBy(this.amount, TimeUnit.SECONDS);
    }

    public ThucydidesFluentWait<T> minute() {
        return this.updateWaitBy(this.amount, TimeUnit.MINUTES);
    }

    public ThucydidesFluentWait<T> minutes() {
        return this.updateWaitBy(this.amount, TimeUnit.MINUTES);
    }

    public ThucydidesFluentWait<T> hour() {
        return this.updateWaitBy(this.amount, TimeUnit.HOURS);
    }

    public ThucydidesFluentWait<T> hours() {
        return this.updateWaitBy(this.amount, TimeUnit.HOURS);
    }
}

