/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Optional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Example {
    private final String description;
    private final Optional<String> cardNumber;
    private static final Optional<String> NO_CARD_NUMBER = Optional.absent();

    public Example(String description, Optional<String> cardNumber) {
        this.description = description;
        this.cardNumber = cardNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<String> getCardNumber() {
        return this.cardNumber;
    }

    public String toString() {
        if (this.cardNumber.isPresent()) {
            return this.description + " [" + this.cardNumber + "]";
        }
        return this.description;
    }

    public static ExampleBuilder withDescription(String description) {
        return new ExampleBuilder(description);
    }

    public static class ExampleBuilder {
        private final String description;

        public ExampleBuilder(String description) {
            this.description = description;
        }

        public Example andCardNumber(String cardNumber) {
            return new Example(this.description, (Optional<String>)Optional.of((Object)cardNumber));
        }

        public Example andNoCardNumber() {
            return new Example(this.description, (Optional<String>)NO_CARD_NUMBER);
        }
    }
}

